//Calculation of Transmission Line parameters using Nominal-pi method//
//This Program requires user input. Sample Problem with user input and result are available in the result file//
//Scilab Version 5.5.2 ; OS:Windows
clc;
clear;
d=input('Enter the value of distance:');
rkm=input('Enter the value of resistance per km:');
xlkm=input('Enter the value of inductive reactance per km:');
yshkm=input('Enter the value of shunt admittance per km:');
pl=input('Enter the value of power delivered:');
vl=input('Enter the value of line voltage:');
pf=input('Enter the value of power factor:');
vr=vl/sqrt(3);         //phase voltage
r=rkm*d;               //total resistance of the transmission line
xl=xlkm*d;             //total inductive reactance of the transmission line
ysh=yshkm*d;           //total shunt admittance of the transmission line
zs=r+(xl*%i);          //total impedance 
a=1+(ysh*zs)/2;          //calculation of transmission line parameters
b=zs;
c=ysh*(1+(ysh*zs)/4); 
d=a;
disp(d,c,b,a,'the values of ABCD parameters respectively are:')
ilo=pl/(sqrt(3)*vl*pf);
sp=sin(acos(pf));
ir=ilo*(pf-%i*sp);
icl=(vr*ysh)/2;
il=ir+icl;
vs=(vr+(il*(r+(%i*xl))));  //sending end voltage
reg=((abs(vs)/abs(a)-abs(vr))/abs(vr))*100;   //calculation of percentage regulation
disp(reg,'regulation of the line is');

//SAMPLE INPUT:
//Enter the value of distance:100
//Enter the value of resistance per km:0.1
//Enter the value of inductive reactance per km:0.2
//Enter the value of shunt admittance per km:4e-6*%i
//Enter the value of power delivered:10e6
//Enter the value of line voltage:66e3
//Enter the value of power factor:0.8
 
 //OUTPUT:
 //the values of ABCD parameters respectively are:   
 
   // 0.996 + 0.002i  
 
    //10. + 20.i  
 
//  - 0.0000004 + 0.0003992i  
 
  //  0.996 + 0.002i  
 
 //regulation of the line is   
 
   // 5.8069405
